within ;
model FinalDrive

  parameter Real ratio(start = 1.0)
    "transmission ratio (flange_a.phi/flange_b.phi)";
  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a
    annotation (Placement(transformation(extent={{-100,-10},{-80,10}})));
  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_b_left annotation (
      Placement(transformation(extent={{70,48},{90,68}}), iconTransformation(
          extent={{70,48},{90,68}})));
  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_b_right annotation (
      Placement(transformation(extent={{70,-70},{90,-50}}), iconTransformation(
          extent={{70,-70},{90,-50}})));
equation
   flange_a.phi/ratio = (flange_b_right.phi + flange_b_left.phi)/2.0;
   flange_a.tau*ratio = -flange_b_left.tau;
   flange_b_left.tau = flange_b_right.tau;
  annotation (uses(Modelica(version="3.2")), Icon(graphics));
end FinalDrive;
